<?php include "koneksi.php"; include "log_helper.php"; ?>
<!DOCTYPE html>
<html>
<head>
<title>Persetujuan Retur</title>
<style>
body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
.container { max-width: 1200px; margin: 0 auto; }
h1 { color: #333; }
h2 { color: #666; margin-top: 30px; }

table { width: 100%; border-collapse: collapse; background: white; margin: 20px 0; }
th, td { padding: 12px; text-align: left; border: 1px solid #ddd; }
th { background: #2196F3; color: white; }
tr:hover { background: #f9f9f9; }

.btn-group { display: flex; gap: 5px; }
.btn { padding: 8px 12px; text-decoration: none; border-radius: 3px; border: none; cursor: pointer; font-size: 13px; }
.btn-setuju { background: #4CAF50; color: white; }
.btn-setuju:hover { background: #45a049; }
.btn-tolak { background: #f44336; color: white; }
.btn-tolak:hover { background: #da190b; }
.btn-kembali { background: #007bff; color: white; }
.btn-kembali:hover { background: #0056b3; }

.status-pending { background: #fff3cd; color: #856404; font-weight: bold; }
.status-disetujui { background: #d4edda; color: #155724; font-weight: bold; }
.status-ditolak { background: #f8d7da; color: #721c24; font-weight: bold; }

.box { background: white; padding: 20px; border-radius: 5px; margin: 20px 0; }
.form-group { margin-bottom: 15px; }
label { display: block; margin-bottom: 5px; font-weight: bold; }
textarea { width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 3px; }

.nav { margin-bottom: 20px; }
.nav a { display: inline-block; padding: 10px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 3px; margin-right: 10px; }
.nav a:hover { background: #0056b3; }

.alert { padding: 15px; border-radius: 5px; margin: 15px 0; }
.alert-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
.alert-info { background: #d1ecf1; color: #0c5460; border: 1px solid #bee5eb; }
</style>
</head>
<body>

<div class="container">
<h1>📦 Persetujuan Retur Barang</h1>

<div class="nav">
<a href="dashboard_admin.php">← Kembali ke Dashboard Admin</a>
</div>

<?php
// PROCESS: Setujui retur
if (isset($_GET['setuju'])) {
    $id_retur = $_GET['setuju'];
    
    // GET INFO RETUR
    $q = mysqli_query($koneksi,"SELECT id_paket, alasan_retur FROM retur WHERE id_retur='$id_retur'");
    $d = mysqli_fetch_array($q);
    $id_paket = $d['id_paket'];
    $alasan = $d['alasan_retur'];
    
    mysqli_query($koneksi,"
        UPDATE retur SET status_retur='Disetujui' 
        WHERE id_retur='$id_retur'
    ");
    
    // LOG AKTIVITAS
    insertLog($koneksi,
        $id_paket,
        'Permintaan Retur',
        'Retur paket DISETUJUI - Alasan: ' . $alasan,
        'Dikirim',
        'Retur Disetujui',
        'admin'
    );
    
    echo "<div class='alert alert-success'>✓ Retur berhasil disetujui!</div>";
}

// PROCESS: Tolak retur
if (isset($_GET['tolak'])) {
    $id_retur = $_GET['tolak'];
    
    // GET INFO RETUR
    $q = mysqli_query($koneksi,"SELECT id_paket, alasan_retur FROM retur WHERE id_retur='$id_retur'");
    $d = mysqli_fetch_array($q);
    $id_paket = $d['id_paket'];
    $alasan = $d['alasan_retur'];
    
    mysqli_query($koneksi,"
        UPDATE retur SET status_retur='Ditolak' 
        WHERE id_retur='$id_retur'
    ");
    
    // LOG AKTIVITAS
    insertLog($koneksi,
        $id_paket,
        'Permintaan Retur',
        'Retur paket DITOLAK - Alasan: ' . $alasan,
        'Dikirim',
        'Retur Ditolak',
        'admin'
    );
    
    echo "<div class='alert alert-success'>✓ Retur berhasil ditolak!</div>";
}

// PROCESS: Input retur baru (dari petugas keluar)
if (isset($_POST['input_retur'])) {
    $id_paket = $_POST['id_paket'];
    $alasan = $_POST['alasan'];
    
    mysqli_query($koneksi,"
        INSERT INTO retur (id_paket, alasan_retur, status_retur, waktu_retur)
        VALUES ('$id_paket', '$alasan', 'Menunggu', NOW())
    ");
    
    // LOG AKTIVITAS
    insertLog($koneksi,
        $id_paket,
        'Permintaan Retur',
        'Retur paket diajukan - Alasan: ' . $alasan,
        'Dikirim',
        'Retur Pending',
        'petugas_keluar'
    );
    
    echo "<div class='alert alert-success'>✓ Retur berhasil diajukan! Menunggu persetujuan admin.</div>";
}
?>

<!-- BAGIAN 1: FORM INPUT RETUR (UNTUK PETUGAS KELUAR) -->
<div class="box">
<h2>1. Ajukan Retur Paket</h2>
<p>Isi form ini jika ada paket yang perlu diretur (rusak, salah alamat, dll)</p>

<form method="post">
<div class="form-group">
<label>Pilih Paket:</label>
<select name="id_paket" required style="width:100%; padding:8px; border:1px solid #ddd; border-radius:3px;">
<option value="">-- Pilih Paket --</option>
<?php
$q = mysqli_query($koneksi,"
SELECT id_paket, no_resi, nama_penerima, nama_barang 
FROM paket 
WHERE status_pengiriman='Dikirim'
ORDER BY id_paket DESC
LIMIT 100
");
while ($d = mysqli_fetch_array($q)) {
    echo "<option value='".$d['id_paket']."'>[".substr($d['no_resi'], -6)."] ".$d['nama_penerima']." - ".$d['nama_barang']."</option>";
}
?>
</select>
</div>

<div class="form-group">
<label>Alasan Retur:</label>
<textarea name="alasan" placeholder="Contoh: Barang rusak, salah alamat, dll" required></textarea>
</div>

<button type="submit" name="input_retur" class="btn btn-setuju" style="width:100%; padding:10px; font-size:14px; font-weight:bold;">📤 Ajukan Retur</button>
</form>
</div>

<!-- BAGIAN 2: DAFTAR RETUR MENUNGGU PERSETUJUAN -->
<h2>2. Retur Menunggu Persetujuan</h2>

<?php
$q = mysqli_query($koneksi,"
SELECT retur.*, paket.no_resi, paket.nama_penerima, paket.nama_barang 
FROM retur 
JOIN paket ON retur.id_paket = paket.id_paket
WHERE retur.status_retur='Menunggu'
ORDER BY retur.waktu_retur DESC
");

$count = mysqli_num_rows($q);
if ($count == 0) {
    echo "<div class='alert alert-info'>Tidak ada retur yang menunggu persetujuan.</div>";
} else {
    echo "<p>Total: <strong>$count</strong> retur menunggu</p>";
    echo "<table>";
    echo "<tr>
            <th>No Resi</th>
            <th>Penerima</th>
            <th>Barang</th>
            <th>Alasan Retur</th>
            <th>Waktu Pengajuan</th>
            <th>Aksi</th>
          </tr>";
    
    while ($d = mysqli_fetch_array($q)) {
        $waktu = new DateTime($d['waktu_retur']);
        $waktu_format = $waktu->format('d-m-Y H:i');
        
        echo "<tr>";
        echo "<td>".$d['no_resi']."</td>";
        echo "<td>".$d['nama_penerima']."</td>";
        echo "<td>".$d['nama_barang']."</td>";
        echo "<td>".$d['alasan_retur']."</td>";
        echo "<td>".$waktu_format."</td>";
        echo "<td>";
        echo "<div class='btn-group'>";
        echo "<a href='?setuju=".$d['id_retur']."' class='btn btn-setuju' onclick='return confirm(\"Setujui retur ini?\");'>Setujui</a>";
        echo "<a href='?tolak=".$d['id_retur']."' class='btn btn-tolak' onclick='return confirm(\"Tolak retur ini?\");'>Tolak</a>";
        echo "</div>";
        echo "</td>";
        echo "</tr>";
    }
    echo "</table>";
}
?>

<!-- BAGIAN 3: RIWAYAT RETUR -->
<h2>3. Riwayat Retur (Disetujui & Ditolak)</h2>

<?php
$q = mysqli_query($koneksi,"
SELECT retur.*, paket.no_resi, paket.nama_penerima, paket.nama_barang 
FROM retur 
JOIN paket ON retur.id_paket = paket.id_paket
WHERE retur.status_retur IN ('Disetujui', 'Ditolak')
ORDER BY retur.waktu_retur DESC
LIMIT 50
");

$count = mysqli_num_rows($q);
if ($count == 0) {
    echo "<div class='alert alert-info'>Belum ada riwayat retur.</div>";
} else {
    echo "<p>Total: <strong>$count</strong> riwayat retur</p>";
    echo "<table>";
    echo "<tr>
            <th>No Resi</th>
            <th>Penerima</th>
            <th>Barang</th>
            <th>Alasan</th>
            <th>Status</th>
            <th>Waktu</th>
          </tr>";
    
    while ($d = mysqli_fetch_array($q)) {
        $waktu = new DateTime($d['waktu_retur']);
        $waktu_format = $waktu->format('d-m-Y H:i');
        
        $status_class = ($d['status_retur'] == 'Disetujui') ? 'status-disetujui' : 'status-ditolak';
        
        echo "<tr>";
        echo "<td>".$d['no_resi']."</td>";
        echo "<td>".$d['nama_penerima']."</td>";
        echo "<td>".$d['nama_barang']."</td>";
        echo "<td>".$d['alasan_retur']."</td>";
        echo "<td class='$status_class'>".$d['status_retur']."</td>";
        echo "<td>".$waktu_format."</td>";
        echo "</tr>";
    }
    echo "</table>";
}
?>

</div>

</body>
</html>
