<?php include "koneksi.php"; ?>
<!DOCTYPE html>
<html>
<head>
<title>Log Aktivitas Paket</title>
<style>
body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
.container { max-width: 1200px; margin: 0 auto; }
h1 { color: #333; }
h2 { color: #666; margin-top: 30px; border-bottom: 2px solid #007bff; padding-bottom: 10px; }

table { width: 100%; border-collapse: collapse; background: white; margin: 20px 0; }
th, td { padding: 12px; text-align: left; border: 1px solid #ddd; }
th { background: #007bff; color: white; font-weight: bold; }
tr:hover { background: #f9f9f9; }

.jenis-input { background: #d1ecf1; color: #0c5460; }
.jenis-pindah { background: #fff3cd; color: #856404; }
.jenis-kirim { background: #d4edda; color: #155724; }
.jenis-retur { background: #f8d7da; color: #721c24; }

.search-box {
    background: white;
    padding: 20px;
    border-radius: 5px;
    margin: 20px 0;
    display: flex;
    gap: 10px;
}

.search-box input {
    padding: 8px;
    border: 1px solid #ddd;
    border-radius: 3px;
    flex: 1;
}

.search-box button {
    padding: 8px 15px;
    background: #007bff;
    color: white;
    border: none;
    border-radius: 3px;
    cursor: pointer;
}

.search-box button:hover {
    background: #0056b3;
}

.nav { margin-bottom: 20px; }
.nav a { display: inline-block; padding: 10px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 3px; margin-right: 10px; }
.nav a:hover { background: #0056b3; }

.stats { display: flex; gap: 20px; margin: 20px 0; flex-wrap: wrap; }
.stat-box { background: white; padding: 15px; border-radius: 5px; flex: 1; min-width: 200px; border-left: 4px solid #007bff; }
.stat-box h3 { margin: 0 0 10px 0; color: #666; font-size: 14px; }
.stat-box .number { font-size: 24px; font-weight: bold; color: #007bff; }

.alert { padding: 15px; border-radius: 5px; margin: 15px 0; }
.alert-info { background: #d1ecf1; color: #0c5460; border: 1px solid #bee5eb; }
</style>
</head>
<body>

<div class="container">
<h1>📋 Log Aktivitas Paket</h1>

<div class="nav">
<a href="dashboard_admin.php">← Kembali ke Dashboard Admin</a>
</div>

<?php
// SEARCH FILTER
$filter_resi = isset($_GET['resi']) ? $_GET['resi'] : '';
$filter_jenis = isset($_GET['jenis']) ? $_GET['jenis'] : '';

$where = "WHERE 1=1";
if (!empty($filter_resi)) {
    $where .= " AND paket.no_resi LIKE '%$filter_resi%'";
}
if (!empty($filter_jenis)) {
    $where .= " AND log_aktivitas.jenis_aktivitas = '$filter_jenis'";
}

// STATISTICS
$q_total = mysqli_query($koneksi,"
SELECT COUNT(*) as total FROM log_aktivitas
");
$total_log = mysqli_fetch_array($q_total)['total'];

$q_input = mysqli_query($koneksi,"
SELECT COUNT(*) as total FROM log_aktivitas 
WHERE jenis_aktivitas='Input Paket'
");
$total_input = mysqli_fetch_array($q_input)['total'];

$q_kirim = mysqli_query($koneksi,"
SELECT COUNT(*) as total FROM log_aktivitas 
WHERE jenis_aktivitas='Pengiriman Paket'
");
$total_kirim = mysqli_fetch_array($q_kirim)['total'];

$q_retur = mysqli_query($koneksi,"
SELECT COUNT(*) as total FROM log_aktivitas 
WHERE jenis_aktivitas='Permintaan Retur'
");
$total_retur = mysqli_fetch_array($q_retur)['total'];
?>

<!-- STATISTICS -->
<div class="stats">
<div class="stat-box">
<h3>Total Log</h3>
<div class="number"><?php echo $total_log; ?></div>
</div>
<div class="stat-box">
<h3>Input Paket</h3>
<div class="number"><?php echo $total_input; ?></div>
</div>
<div class="stat-box">
<h3>Pengiriman</h3>
<div class="number"><?php echo $total_kirim; ?></div>
</div>
<div class="stat-box">
<h3>Retur</h3>
<div class="number"><?php echo $total_retur; ?></div>
</div>
</div>

<!-- SEARCH FILTER -->
<div class="search-box">
<input type="text" id="filterResi" placeholder="Cari nomor resi..." value="<?php echo htmlspecialchars($filter_resi); ?>">
<select id="filterJenis" style="padding: 8px; border: 1px solid #ddd; border-radius: 3px;">
<option value="">-- Semua Jenis --</option>
<option value="Input Paket" <?php echo ($filter_jenis == 'Input Paket') ? 'selected' : ''; ?>>Input Paket</option>
<option value="Pengiriman Paket" <?php echo ($filter_jenis == 'Pengiriman Paket') ? 'selected' : ''; ?>>Pengiriman</option>
<option value="Permintaan Retur" <?php echo ($filter_jenis == 'Permintaan Retur') ? 'selected' : ''; ?>>Retur</option>
<option value="Perubahan Status" <?php echo ($filter_jenis == 'Perubahan Status') ? 'selected' : ''; ?>>Perubahan Status</option>
</select>
<button onclick="applyFilter()">🔍 Cari</button>
</div>

<!-- LOG TABLE -->
<h2>📊 Riwayat Aktivitas</h2>

<?php
$q = mysqli_query($koneksi,"
SELECT log_aktivitas.*, paket.no_resi, paket.nama_penerima, paket.nama_barang
FROM log_aktivitas
LEFT JOIN paket ON log_aktivitas.id_paket = paket.id_paket
$where
ORDER BY log_aktivitas.waktu_log DESC
LIMIT 100
");

$count = mysqli_num_rows($q);

if ($count == 0) {
    echo "<div class='alert alert-info'>Tidak ada data log aktivitas untuk kriteria pencarian Anda.</div>";
} else {
    echo "<p>Total: <strong>$count</strong> log aktivitas</p>";
    echo "<table>";
    echo "<tr>
            <th>Waktu</th>
            <th>No Resi</th>
            <th>Nama Penerima</th>
            <th>Jenis Aktivitas</th>
            <th>Deskripsi</th>
            <th>Status</th>
            <th>User</th>
          </tr>";
    
    while ($d = mysqli_fetch_array($q)) {
        $waktu = new DateTime($d['waktu_log']);
        $waktu_format = $waktu->format('d-m-Y H:i:s');
        
        // Tentukan class untuk jenis aktivitas
        $jenis = $d['jenis_aktivitas'];
        $class = 'jenis-input';
        if (strpos($jenis, 'Pengiriman') !== false) {
            $class = 'jenis-kirim';
        } elseif (strpos($jenis, 'Retur') !== false) {
            $class = 'jenis-retur';
        } elseif (strpos($jenis, 'Pindah') !== false) {
            $class = 'jenis-pindah';
        }
        
        // Status display
        $status_display = '';
        if (!empty($d['status_sebelum']) && !empty($d['status_sesudah'])) {
            $status_display = $d['status_sebelum'] . ' → ' . $d['status_sesudah'];
        }
        
        echo "<tr>";
        echo "<td>".$waktu_format."</td>";
        echo "<td><strong>".(isset($d['no_resi']) ? $d['no_resi'] : '-')."</strong></td>";
        echo "<td>".(isset($d['nama_penerima']) ? $d['nama_penerima'] : '-')."</td>";
        echo "<td class='$class'><strong>".$jenis."</strong></td>";
        echo "<td>".$d['deskripsi']."</td>";
        echo "<td>$status_display</td>";
        echo "<td>".(isset($d['user_id']) ? $d['user_id'] : 'Sistem')."</td>";
        echo "</tr>";
    }
    echo "</table>";
}
?>

</div>

<script>
function applyFilter() {
    const resi = document.getElementById('filterResi').value;
    const jenis = document.getElementById('filterJenis').value;
    
    let url = 'log_aktivitas.php?';
    if (resi) url += 'resi=' + encodeURIComponent(resi);
    if (jenis) url += (resi ? '&' : '') + 'jenis=' + encodeURIComponent(jenis);
    
    window.location.href = url;
}

// Allow Enter key in search box
document.getElementById('filterResi').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') applyFilter();
});
</script>

</body>
</html>
