<?php include "koneksi.php"; ?>
<!DOCTYPE html>
<html>
<head>
<title>Dashboard Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background: #f5f5f5; padding: 20px; }
.container-main { max-width: 1400px; margin: 0 auto; }
h2 { color: #333; margin-bottom: 30px; }
.stats { display: flex; gap: 20px; margin: 30px 0; flex-wrap: wrap; }
.stat-card { background: white; padding: 20px; border-radius: 10px; flex: 1; min-width: 200px; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); border-left: 4px solid #667eea; }
.stat-card h5 { color: #666; font-size: 14px; margin-bottom: 10px; }
.stat-card .number { font-size: 32px; font-weight: bold; color: #667eea; }
.action-buttons { display: flex; gap: 10px; margin-bottom: 30px; flex-wrap: wrap; }
.action-buttons a { flex: 1; min-width: 150px; }
table { margin-top: 0 !important; }
th { background: #667eea; color: white; }
</style>
</head>
<body>

<div class="container-main">
<h2>🏢 Dashboard Admin Gudang</h2>

<!-- ACTION BUTTONS -->
<div class="action-buttons">
<a href="chart.php" class="btn btn-success">📊 Lihat Grafik Paket</a>
<a href="sla_checker.php" class="btn btn-warning">⏰ Monitoring SLA</a>
<a href="log_aktivitas.php" class="btn btn-info">📋 Log Aktivitas</a>
<a href="retur_approval.php" class="btn btn-primary">📦 Persetujuan Retur</a>
</div>

<?php
$total = mysqli_num_rows(mysqli_query($koneksi,"SELECT id_paket FROM paket"));
$menunggu = mysqli_num_rows(mysqli_query($koneksi,"SELECT id_paket FROM paket WHERE status_pengiriman='Menunggu'"));
$dikirim = mysqli_num_rows(mysqli_query($koneksi,"SELECT id_paket FROM paket WHERE status_pengiriman='Dikirim'"));
$retur = mysqli_num_rows(mysqli_query($koneksi,"SELECT id_retur FROM retur WHERE status_retur='Menunggu'"));
?>

<!-- STATISTICS -->
<div class="stats">
<div class="stat-card">
<h5>📦 Total Paket Masuk</h5>
<div class="number"><?php echo $total; ?></div>
</div>
<div class="stat-card">
<h5>⏳ Paket Menunggu Dikirim</h5>
<div class="number"><?php echo $menunggu; ?></div>
</div>
<div class="stat-card">
<h5>✈️ Paket Sudah Dikirim</h5>
<div class="number"><?php echo $dikirim; ?></div>
</div>
<div class="stat-card">
<h5>🔄 Retur Menunggu Persetujuan</h5>
<div class="number" style="color: #ff6b6b;"><?php echo $retur; ?></div>
</div>
</div>

<!-- MONITORING TABLE -->
<div class="card">
<div class="card-header" style="background: #667eea; color: white;">
<h5 class="mb-0">📊 Monitoring Paket Terbaru (25 Data)</h5>
</div>
<div class="card-body">
<div class="table-responsive">
<table class="table table-striped">
<tr>
<th>Resi</th>
<th>Penerima</th>
<th>Barang</th>
<th>Tipe Pengiriman</th>
<th>Status</th>
<th>Rak</th>
</tr>

<?php
$q = mysqli_query($koneksi,"
SELECT paket.*, rak.nama_rak 
FROM paket 
LEFT JOIN rak ON paket.id_rak=rak.id_rak
ORDER BY paket.id_paket DESC
LIMIT 25
");

while ($d = mysqli_fetch_array($q)) {
    $badge_color = ($d['status_pengiriman'] == 'Menunggu') ? 'warning' : 'success';
?>
<tr>
<td><strong><?php echo $d['no_resi']; ?></strong></td>
<td><?php echo $d['nama_penerima']; ?></td>
<td><?php echo $d['nama_barang']; ?></td>
<td><?php echo $d['tipe_pengiriman']; ?></td>
<td><span class="badge bg-<?php echo $badge_color; ?>"><?php echo $d['status_pengiriman']; ?></span></td>
<td><?php echo $d['nama_rak'] ?? '-'; ?></td>
</tr>
<?php } ?>
</table>
</div>
</div>
</div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
