const heroImages = [
  `${window.BASE_URL || ''}/img/kantor.jpg`,
  `${window.BASE_URL || ''}/img/Lambang_Kota_Tangerang_Selatan.png`,
  `${window.BASE_URL || ''}/img/drafLurah.jpg`
];

let heroIndex = 0;
const heroImgEl = document.querySelector('.hero-image');

function nextHeroImage() {
  if (!heroImgEl) return;
  heroIndex = (heroIndex + 1) % heroImages.length;
  heroImgEl.classList.add('fade-out');
  setTimeout(() => {
    heroImgEl.src = heroImages[heroIndex];
    heroImgEl.classList.remove('fade-out');
  }, 400);
}

setInterval(nextHeroImage, 3500);

// === SIDEBAR VERTIKAL ===
const sidebar = document.getElementById('sidebar');
const sidebarToggle = document.getElementById('sidebar-toggle');
if (sidebar && sidebarToggle) {
  sidebarToggle.addEventListener('click', function() {
    sidebar.classList.toggle('open');
    document.body.classList.toggle('sidebar-active', sidebar.classList.contains('open'));
  });
}
// Dropdown toggle
const dropdownToggles = document.querySelectorAll('.sidebar-dropdown-toggle');
dropdownToggles.forEach(btn => {
  btn.addEventListener('click', function(e) {
    e.stopPropagation();
    const parent = btn.closest('.sidebar-dropdown');
    const expanded = btn.getAttribute('aria-expanded') === 'true';
    btn.setAttribute('aria-expanded', !expanded);
    parent.classList.toggle('open', !expanded);
    // Tutup dropdown lain
    dropdownToggles.forEach(other => {
      if (other !== btn) {
        other.setAttribute('aria-expanded', 'false');
        other.closest('.sidebar-dropdown').classList.remove('open');
      }
    });
  });
});
// Tutup sidebar/dropdown saat klik di luar
window.addEventListener('click', function(e) {
  if (!e.target.closest('.sidebar')) {
    sidebar && sidebar.classList.remove('open');
    document.body.classList.remove('sidebar-active');
    dropdownToggles.forEach(btn => {
      btn.setAttribute('aria-expanded', 'false');
      btn.closest('.sidebar-dropdown').classList.remove('open');
    });
  }
});
// Tutup sidebar saat overlay diklik (mobile)
const sidebarOverlay = document.querySelector('.sidebar-overlay');
if (sidebarOverlay) {
  sidebarOverlay.addEventListener('click', function() {
    sidebar && sidebar.classList.remove('open');
    document.body.classList.remove('sidebar-active');
  });
}
// === MOBILE NAVBAR SLIDE DOWN ===
const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
if (mobileMenuToggle && sidebar) {
  mobileMenuToggle.addEventListener('click', function(e) {
    e.stopPropagation();
    sidebar.classList.toggle('open');
    document.body.classList.toggle('sidebar-active', sidebar.classList.contains('open'));
  });
}
if (sidebarOverlay) {
  sidebarOverlay.addEventListener('click', function() {
    sidebar && sidebar.classList.remove('open');
    document.body.classList.remove('sidebar-active');
  });
}

// Mobile menu toggle
const menuToggle = document.querySelector('.menu-toggle');
const navList = document.querySelector('.nav-list');
menuToggle.addEventListener('click', () => {
  const expanded = menuToggle.getAttribute('aria-expanded') === 'true' || false;
  menuToggle.setAttribute('aria-expanded', !expanded);
  navList.classList.toggle('nav-list-active');
});

// Dropdown menus accessibility and toggle
const dropdownButtons = document.querySelectorAll('.nav-dropdown > .nav-button');
dropdownButtons.forEach((btn) => {
  btn.addEventListener('click', () => {
    const expanded = btn.getAttribute('aria-expanded') === 'true';
    dropdownButtons.forEach(b => {
      if (b !== btn) {
        b.setAttribute('aria-expanded', 'false');
        b.nextElementSibling.style.display = 'none';
      }
    });
    btn.setAttribute('aria-expanded', String(!expanded));
    const menu = btn.nextElementSibling;
    if (!expanded) {
      menu.style.display = 'block';
    } else {
      menu.style.display = 'none';
    }
  });
});

// Close dropdowns and menu when clicking outside
document.addEventListener('click', (e) => {
  if (!e.target.closest('.navbar') && !e.target.closest('.nav-button')) {
    dropdownButtons.forEach((btn) => {
      btn.setAttribute('aria-expanded', 'false');
      btn.nextElementSibling.style.display = 'none';
    });
    navList.classList.remove('nav-list-active');
    menuToggle.setAttribute('aria-expanded', 'false');
  }
});
