<div style="
  min-height: 100vh;
  background: url('<?= BASE_URL ?>/foto_beranda/Lambang_Kota_Tangerang_Selatan.png') no-repeat center center;
  background-size: cover;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 6vw 2vw 8vw 2vw;
">
  <h2 style="font-size: clamp(1.3rem, 4vw, 2.2rem); font-weight: bold; margin-bottom: 2rem; letter-spacing: 2px; text-align: center; color: black; text-shadow: 1px 1px 4px black;">
    STRUKTUR ORGANISASI
  </h2>
  <?php 
    require_once __DIR__ . '/../../../Models/StrukturOrganisasi.php';
    $strukturModel = new StrukturOrganisasi();
    $img = $strukturModel->getLatestImage();
    $struktur_gambar_url = $img && !empty($img['file_path']) ? BASE_URL . '/public/' . $img['file_path'] : '';
  ?>
  <?php if ($struktur_gambar_url): ?>
    <img src="<?= $struktur_gambar_url ?>" alt="Struktur Organisasi" style="max-width: 100%; height: auto; box-shadow: 0 0 10px rgba(0,0,0,0.5);">
  <?php else: ?>
    <div style="color:white;text-shadow:1px 1px 4px black;">Belum ada gambar struktur organisasi diupload.</div>
  <?php endif; ?>
  <?php if (!empty($data['struktur'])): ?>
    <div style="margin-top:2.5rem; width:100%; display:flex; flex-wrap:wrap; gap:2rem; justify-content:center; align-items:stretch;">
      <?php foreach($data['struktur'] as $row): ?>
        <div style="background:#fff; border-radius:16px; box-shadow:0 2px 12px rgba(0,0,0,0.08); width:220px; min-height:340px; display:flex; flex-direction:column; align-items:center; justify-content:flex-start; overflow:hidden;">
          <div style="width:100%; height:180px; display:flex; align-items:center; justify-content:center; background:#fff;">
            <?php if (!empty($row['anggota_foto'])): ?>
              <img src="<?= BASE_URL . '/public/' . $row['anggota_foto'] ?>" alt="<?= htmlspecialchars($row['anggota_nama']) ?>" style="width:120px; height:160px; object-fit:cover; border-radius:8px; box-shadow:0 2px 8px rgba(0,0,0,0.10); background:#fff; border:3px solid #fff; margin-top:10px;" loading="lazy">
            <?php else: ?>
              <div style="width:120px; height:160px; background:#e5e7eb; border-radius:8px; display:flex; align-items:center; justify-content:center; color:#888; font-size:2.5rem;">👤</div>
            <?php endif; ?>
          </div>
          <div style="padding:1.2rem 1rem 0.5rem 1rem; width:100%; text-align:center; flex:1; display:flex; flex-direction:column; justify-content:flex-start;">
            <div style="font-size:1.1rem; font-weight:600; color:#222; margin-bottom:0.2rem; letter-spacing:0.5px; line-height:1.2;">
              <?= htmlspecialchars($row['anggota_nama']) ?>
            </div>
            <div style="font-size:1rem; color:#22c55e; font-weight:500; margin-bottom:0.2rem; line-height:1.2;">
              <?= htmlspecialchars($row['jabatan_nama']) ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>
