<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $data['pageTitle'] ?? 'Admin - Struktur Organisasi'; ?></title>
    <?php if (isset($data['cssFiles']) && is_array($data['cssFiles'])): ?>
        <?php foreach ($data['cssFiles'] as $cssFile): ?>
            <link rel="stylesheet" href="<?= BASE_URL . '/public/' . $cssFile; ?>" />
        <?php endforeach; ?>
    <?php endif; ?>
    <style>
        .modal {
            display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100vw; height: 100vh;
            background: rgba(0,0,0,0.3); justify-content: center; align-items: center;
        }
        .modal.active { display: flex; }
        .modal-content {
            background: #fff; padding: 2rem; border-radius: 8px; min-width: 350px; max-width: 500px; width: 100%;
            box-shadow: 0 2px 16px rgba(0,0,0,0.2);
        }
        .modal-header { display: flex; justify-content: space-between; align-items: center; }
        .modal-header h3 { margin: 0; }
        .close-btn { background: none; border: none; font-size: 1.5em; cursor: pointer; }
        .form-group { margin-bottom: 1rem; }
        .form-group label { display: block; margin-bottom: 0.5rem; }
        .form-actions { display: flex; gap: 1rem; justify-content: flex-end; }
        .table-container { margin-top: 2rem; }
        .btn { padding: 0.5rem 1rem; border: none; border-radius: 4px; cursor: pointer; }
        .btn-primary { background: #1976d2; color: #fff; }
        .btn-secondary { background: #aaa; color: #fff; }
        .btn-warning { background: #ff9800; color: #fff; }
        .btn-danger { background: #e53935; color: #fff; }
        .table img { transition: transform 0.2s; }
        .table img:hover { transform: scale(1.1); }
    </style>
</head>
<body>
<?php include 'sidebar.php'; ?>
<div class="main" id="main">
    <div class="page-header">
        <h2>Manajemen Struktur Organisasi</h2>
    </div>
    <?php if (!empty($_SESSION['flash_message'])): ?>
        <div class="alert alert-<?= $_SESSION['flash_message']['type'] ?>">
            <?= $_SESSION['flash_message']['message'] ?>
        </div>
        <?php unset($_SESSION['flash_message']); ?>
    <?php endif; ?>
    <div class="table-container" style="max-width:600px;margin:auto;">
        <form method="POST" action="<?= BASE_URL ?>/admin/strukturOrganisasiUpload" enctype="multipart/form-data">
            <div class="form-group">
                <label for="struktur_gambar">Upload Gambar Struktur Organisasi:</label>
                <input type="file" name="struktur_gambar" id="struktur_gambar" class="form-control" accept="image/*" required>
                <small class="form-text text-muted">Format: JPG, PNG, GIF. Maksimal 2MB</small>
            </div>
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Upload</button>
            </div>
        </form>
        <?php 
            require_once __DIR__ . '/../../Models/StrukturOrganisasi.php';
            $strukturModel = new StrukturOrganisasi();
            $img = $strukturModel->getLatestImage();
            $struktur_gambar_url = $img && !empty($img['file_path']) ? BASE_URL . '/public/' . $img['file_path'] : '';
        ?>
        <?php if ($struktur_gambar_url): ?>
            <div style="margin-top:2rem;text-align:center;">
                <h4>Preview Struktur Organisasi Saat Ini:</h4>
                <img src="<?= $struktur_gambar_url ?>" alt="Struktur Organisasi" style="max-width:100%;height:auto;box-shadow:0 0 10px rgba(0,0,0,0.2);">
                <form method="POST" action="<?= BASE_URL ?>/admin/strukturOrganisasiDeleteImage" style="margin-top: 1rem;">
                    <button type="submit" class="btn btn-danger" onclick="return confirm('Yakin ingin menghapus gambar struktur organisasi?')">Hapus Gambar</button>
                </form>
            </div>
        <?php else: ?>
            <div style="margin-top:2rem;text-align:center; color:#888;">Belum ada gambar struktur organisasi diupload.</div>
        <?php endif; ?>
    </div>
</div>
<script>
function showModal() {
    document.getElementById('strukturModal').classList.add('active');
    document.getElementById('modalTitle').textContent = 'Tambah Struktur Organisasi';
    document.getElementById('strukturForm').reset();
    document.getElementById('strukturId').value = '';
}
function hideModal() {
    document.getElementById('strukturModal').classList.remove('active');
}
function editStruktur(item) {
    showModal();
    document.getElementById('modalTitle').textContent = 'Edit Struktur Organisasi';
    document.getElementById('strukturId').value = item.id;
    document.getElementById('jabatan').value = item.jabatan_id;
    document.getElementById('anggota').value = item.anggota_id;
    document.getElementById('parent_id').value = item.atasan_id;
    document.getElementById('urutan').value = item.urutan;
}
</script>
</body>
</html> 